<?php

namespace NagaTheme\WPForms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AddonTextDomain {

	private static $instance = null;

	private $active_plugins;

	private $addons = [
		'wpforms-activecampaign/wpforms-activecampaign.php' => 'wpforms-activecampaign',
		'wpforms-authorize-net/wpforms-authorize-net.php' => 'wpforms-authorize-net',
		'wpforms-aweber/wpforms-aweber.php'               => 'wpforms-aweber',
		'wpforms-calculations/wpforms-calculations.php'   => 'wpforms-calculations',
		'wpforms-campaign-monitor/wpforms-campaign-monitor.php' => 'wpforms-campaign-monitor',
		'wpforms-conversational-forms/wpforms-conversational-forms.php' => 'wpforms-conversational-forms',
		'wpforms-convertkit/wpforms-convertkit.php'       => 'wpforms-convertkit',
		'wpforms-coupons/wpforms-coupons.php'             => 'wpforms-coupons',
		'wpforms-drip/wpforms-drip.php'                   => 'wpforms-drip',
		'wpforms-dropbox/wpforms-dropbox.php'             => 'wpforms-drip',
		'wpforms-form-abandonment/wpforms-form-abandonment.php' => 'wpforms-form-abandonment',
		'wpforms-form-locker/wpforms-form-locker.php'     => 'wpforms-form-locker',
		'wpforms-form-pages/wpforms-form-pages.php'       => 'wpforms-form-pages',
		'wpforms-geolocation/wpforms-geolocation.php'     => 'wpforms-geolocation',
		'wpforms-getresponse/wpforms-getresponse.php'     => 'wpforms-getresponse',
		'wpforms-hubspot/wpforms-hubspot.php'             => 'wpforms-hubspot',
		'wpforms-lead-forms/wpforms-lead-forms.php'       => 'wpforms-lead-forms',
		'wpforms-mailchimp/wpforms-mailchimp.php'         => 'wpforms-mailchimp',
		'wpforms-mailerlite/wpforms-mailerlite.php'       => 'wpforms-mailerlite',
		'wpforms-offline-forms/wpforms-offline-forms.php' => 'wpforms-offline-forms',
		'wpforms-paypal-commerce/wpforms-paypal-commerce.php' => 'wpforms-paypal-commerce',
		'wpforms-paypal-standard/wpforms-paypal-standard.php' => 'wpforms-paypal-standard',
		'wpforms-post-submissions/wpforms-post-submissions.php' => 'wpforms-post-submissions',
		'wpforms-salesforce/wpforms-salesforce.php'       => 'wpforms-salesforce',
		'wpforms-save-resume/wpforms-save-resume.php'     => 'wpforms-save-resume',
		'wpforms-sendinblue/wpforms-sendinblue.php'       => 'wpforms-sendinblue',
		'wpforms-signatures/wpforms-signatures.php'       => 'wpforms-signatures',
		'wpforms-slack/wpforms-slack.php'                 => 'wpforms-slack',
		'wpforms-square/wpforms-square.php'               => 'wpforms-square',
		'wpforms-stripe/wpforms-stripe.php'               => 'wpforms-stripe',
		'wpforms-surveys-polls/wpforms-surveys-polls.php' => 'wpforms-surveys-polls',
		'wpforms-twilio/wpforms-twilio.php'               => 'wpforms-twilio',
		'wpforms-user-journey/wpforms-user-journey.php'   => 'wpforms-user-journey',
		'wpforms-user-registration/wpforms-user-registration.php' => 'wpforms-user-registration',
		'wpforms-webhooks/wpforms-webhooks.php'           => 'wpforms-webhooks',
		'wpforms-zapier/wpforms-zapier.php'               => 'wpforms-zapier',
	];

	private function __construct() {

		$this->active_plugins = get_option( 'active_plugins', [] );
		$this->load_textdomain();
	}

	public static function get_instance() {

		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function load_textdomain() {

		foreach ( $this->addons as $plugin => $text_domain ) {

			if ( in_array( $plugin, $this->active_plugins, true ) ) {

				$plugin_path     = plugin_dir_path( WP_PLUGIN_DIR . '/' . $plugin );
				$plugin_rel_path = plugin_basename( $plugin_path . '/languages/' );
				load_plugin_textdomain( $text_domain, false, $plugin_rel_path );
			}
		}
	}
}

add_action( 'wpforms_loaded', [ 'NagaTheme\WPForms\AddonTextDomain', 'get_instance' ], 0 );
