<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define the necessary constants for later use.
define( 'NAGATHEME_WPFORMS_FILE', __FILE__ );

define( 'NAGATHEME_WPFORMS_PATH', plugin_dir_path( __FILE__ ) );

define( 'NAGATHEME_WPFORMS_URL', plugin_dir_url( __FILE__ ) );

require_once NAGATHEME_WPFORMS_PATH . 'includes/requirements.php';

use NagaTheme\WPForms\Includes\Requirements;

if ( Requirements::run_compatibility_check() ) {

	// Load NagaTheme License, RTL and Persian Files
	require_once( NAGATHEME_WPFORMS_PATH . 'naga-wpforms-ic.php' );
	require_once( NAGATHEME_WPFORMS_PATH . 'includes/naga-wpforms-addons.php' );

} else {

	// Requirements are not met.
	// NagaTheme functionalities are required in case for WPForms to work properly.
	add_action(
		'admin_menu',
		function () {
			global $submenu;
			$slug = 'wpforms-overview';
			remove_menu_page( $slug );
			if ( isset( $submenu[ $slug ] ) ) {
				unset( $submenu[ $slug ] );
			}
		},
		999999
	);
}
