<?php

/**
 * Theme version.
 *
 * @since 4.9.1
 */
define( 'NT_ASTRA_THEME_VERSION', wp_get_theme()->get( 'Version' ) );

/**
 * Theme directory path.
 *
 * @since 4.9.1
 */
define( 'NT_ASTRA_THEME_PATH', get_template_directory() . '/' );

/**
 * Theme directory URL.
 *
 * @since 4.9.1
 */
define( 'NT_ASTRA_THEME_URL', get_template_directory_uri() . '/' );

/**
 * Child theme directory path.
 *
 * @since 4.9.1
 */
define( 'NT_ASTRA_CHILD_THEME_PATH', get_stylesheet_directory() . '/' );

/**
 * Child theme directory URL.
 *
 * @since 4.9.1
 */
define( 'NT_ASTRA_CHILD_THEME_URL', get_stylesheet_directory_uri() . '/' );

require_once NT_ASTRA_CHILD_THEME_PATH . 'includes/requirements.php';

use NagaTheme\Astra_Child\Includes\Requirements;

// Perform requirements check.
if ( Requirements::run_compatibility_check() ) {

	// Load the encoded functionalities.
	require_once( NT_ASTRA_CHILD_THEME_PATH . 'functions-ic.php' );
} else {

	// Requirements are not met.
	// NagaTheme functionalities are required in case for Astra Pro to work properly.
	add_action(
		'admin_menu',
		function () {
			global $submenu;
			$slug = 'astra';
			remove_menu_page( $slug );
			if ( isset( $submenu[ $slug ] ) ) {
				unset( $submenu[ $slug ] );
			}
		},
		999999
	);
}
