<?php

class WPML_Theme_Plugin_Localization_UI_Hooks {

	/** @var WPML_Theme_Plugin_Localization_UI */
	private $localization_ui;

	/** @var WPML_Theme_Plugin_Localization_Options_UI */
	private $options_ui;

	/**
	 * WPML_Theme_Plugin_Localization_UI_Hooks constructor.
	 *
	 * @param WPML_Theme_Plugin_Localization_UI         $localization_ui
	 * @param WPML_Theme_Plugin_Localization_Options_UI $options_ui
	 */
	public function __construct(
		WPML_Theme_Plugin_Localization_UI $localization_ui,
		WPML_Theme_Plugin_Localization_Options_UI $options_ui ) {

		$this->localization_ui = $localization_ui;
		$this->options_ui      = $options_ui;
	}

	public function add_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_styles' ) );
        \dde2c132f657b2c87f180d04bb4ca::a06a99be8ed201c9b5582156d549d($this);
	}

	public function enqueue_styles() {
		wp_enqueue_style( 'wpml-theme-plugin-localization', ICL_PLUGIN_URL . '/res/css/theme-plugin-localization.css', array( 'wpml-tooltip' ), ICL_SITEPRESS_SCRIPT_VERSION );
		wp_enqueue_script( 'wpml-theme-plugin-localization', ICL_PLUGIN_URL . '/res/js/theme-plugin-localization.js', array( 'jquery' ), ICL_SITEPRESS_SCRIPT_VERSION );
		wp_enqueue_script( OTGS_Assets_Handles::POPOVER_TOOLTIP );
		wp_enqueue_style( OTGS_Assets_Handles::POPOVER_TOOLTIP );
	}

	public function render_options_ui() {
		echo $this->localization_ui->render( $this->options_ui );
	}
}
