<?php //PHPCS:ignore WordPress.Files.FileName.InvalidClassFileName
/**
 * Convert Pro Automation file
 *
 * @package Convert Pro Addon
 */

/**
 * SureTriggers
 */
class CP_SureTriggers {

	/**
	 * Constructor of the file.
	 */
	public function __construct() {
		$this->render_integrations();
	}

	/**
	 * Check if SureTriggers is installed and activated
	 *
	 * @return string
	 */
	public function suretriggers_installed_and_activated() {
		// Include the plugin.php file if not already included.
		if ( ! function_exists( 'is_plugin_active' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		$plugin_slug = 'suretriggers/suretriggers.php';

		if ( is_plugin_active( $plugin_slug ) ) {
			return 'activated';
		} elseif ( file_exists( WP_PLUGIN_DIR . '/' . $plugin_slug ) ) {
			return 'installed';
		} else {
			return 'not_installed';
		}
	}

	/**
	 * Render the integrations page
	 *
	 * @return void
	 */
	public function render_integrations() {

		$status       = $this->suretriggers_installed_and_activated();
		$button_label = __( 'Configure Integration', 'convertpro-addon' );
		$button_class = 'suretriggers-active';

		$is_suretrigger_connected = apply_filters( 'suretriggers_is_user_connected', '' );

		$plugin = 'suretriggers/suretriggers.php';

		if ( 'installed' === $status ) {
			$button_label = __( 'Activate', 'convertpro-addon' );
			$button_class = 'suretriggers-installed';
		} elseif ( 'not_installed' === $status ) {
			$button_label = __( 'Install & Activate', 'convertpro-addon' );
			$button_class = 'suretriggers-not-installed';
		} elseif ( ! $is_suretrigger_connected ) {
			$button_label = __( 'Connect with SureTriggers', 'convertpro-addon' );
			$button_class = 'suretriggers-not-connected';
		}

		$button = '<a href="#" class="button-primary cp-integrations-action ' . esc_attr( $button_class ) . '">' . esc_html( $button_label ) . '</a>';
		?>
		<div id="cp-integrations-suretriggers">
			<div class="cp-integrations-wrapper" style="display:none;" >
				<div class="cp-integrations-container">
					<div class="cp-integrations-content">
						<h3><?php echo esc_html__( 'Integration Powered by SureTriggers', 'convertpro-addon' ); ?></h3>
						<p><?php echo esc_html__( 'SureTriggers connects with over hundreds of apps, enabling you to automate tasks like sending feedback via email or SMS. With Convert Pro and SureTriggers, you can manage any automation needs.', 'convertpro-addon' ); ?></p>
						<ul>
							<li><?php echo esc_html__( '✔ Automate Repetitive Tasks', 'convertpro-addon' ); ?></li>
							<li><?php echo esc_html__( '✔ Connect with hundreds of apps', 'convertpro-addon' ); ?></li>
							<li><?php echo esc_html__( '✔ No code required', 'convertpro-addon' ); ?></li>
							<li><?php echo esc_html__( '✔ Save Time & Money', 'convertpro-addon' ); ?></li>
							<li><?php echo esc_html__( '✔ Free forever for basic features', 'convertpro-addon' ); ?></li>
							<li><?php echo esc_html__( '✔ And more...', 'convertpro-addon' ); ?></li>
						</ul>
						<?php echo wp_kses_post( $button ); ?>
					</div>
					<div class="cp-integrations-icons">
						<img src="<?php echo esc_url( CP_AUTOMATION_BASE_URL . '/assets/img/suretriggers.png' ); ?>" alt="SureTriggers" />
					</div>
				</div>
			</div>
			<?php if ( 'suretriggers-active' === $button_class ) { ?>
				<div class="cp-suretriggers-wrap" style="display:none;" >
					<div class="cp-suretriggers-inner-wrap">
						<div class="cp-suretriggers-title">
							<h5><?php echo esc_html__( 'SureTriggers Integration', 'convertpro-addon' ); ?></h5>
						</div>
						<div class="cp-st-modal-separator"></div>
							<div class="cp-suretriggers-embed">
								<script>
									jQuery(document).ready(function($) {
										var embeddedUrl = "<?php echo apply_filters( 'suretriggers_get_iframe_url', 'https://app.suretriggers.com/' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>";
										SureTriggers.init({
											"client_id": "convertpro",
											"st_embed_url": embeddedUrl,
											"embedded_identifier": "cp-",
											"target": "suretriggers-iframe-wrapper",
											"integration": "ConvertPro",
											"summary": "Create new workflow",
											"selected_options": {},
											"sample_response": {},
											"configure_trigger": true,
											"trigger_allowed_apps": ["ConvertPro"],
											"event": {
												"value": "convert_pro_form_submit",
												"label": "Form Submitted",
												"description": "Runs when a form is submitted by user."
											},
											"show_all_workflows": true
										});
									});
								</script>
								<div id="suretriggers-iframe-wrapper"></div>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
		<?php
	}

}

// Instantiate the class to add the submenu.
new CP_SureTriggers();
