<?php
/**
 * Convert Pro Addon Automation Test loader file
 *
 * @package Convert Pro Addon
 * @author Brainstorm Force
 */

// Prohibit direct script loading.
defined( 'ABSPATH' ) || die( 'No direct script access allowed!' );

if ( ! class_exists( 'CPRO_Automation_Loader' ) ) {

	/**
	 * Responsible for setting up constants, classes and includes.
	 *
	 * @since x.x.x
	 */
	final class CPRO_Automation_Loader {

		/**
		 * Class Instance.
		 *
		 * @since x.x.x
		 * @access private
		 * @var array $instance
		 */
		private static $instance;

		/**
		 * Gets an instance of our plugin.
		 */
		public static function get_instance() {

			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Constructor.
		 */
		public function __construct() {

			$this->define_constants();
			$this->load_files();

			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
			add_action( 'bsf_menu_automation_action', array( $this, 'automation_page' ) );
			add_filter( 'bsf_menu_options', array( $this, 'add_automation_menu' ) );
		}

		/**
		 * Adds menu.
		 *
		 * @since x.x.x
		 * @param array $options Option array.
		 * @return array $return_options
		 */
		public function add_automation_menu( $options ) {
			$return_options = array();
			foreach ( $options as $key => $value ) {

				$return_options[ $key ] = $value;
				if ( 'create-new' === $key && ! isset( $options['automation'] ) ) {
					$return_options['automation'] = array(
						'name' => __( 'Automations', 'convertpro-addon' ),
						'link' => false,
					);
				}
			}
			return $return_options;
		}

		/**
		 * Loads Main page.
		 *
		 * @since x.x.x
		 * @return void
		 */
		public function automation_page() {
			require_once CP_AUTOMATION_BASE_DIR . 'main.php';
		}

		/**
		 * Renders an admin scripts.
		 *
		 * @since x.x.x
		 * @param string $hook Action string.
		 * @return void
		 */
		public function admin_scripts( $hook ) {
			if ( isset( $_REQUEST['cpro_admin_page_menu_nonce'] ) && ! wp_verify_nonce( $_REQUEST['cpro_admin_page_menu_nonce'], 'cpro_admin_page_menu' ) ) {
				die( 'No direct script access allowed!' );
			}
			$current_screen = get_current_screen();

			if ( false !== strpos( $hook, CP_PRO_SLUG . '-automation' )
				|| (
					false !== strpos( $hook, CP_PRO_SLUG )
					&& isset( $_GET['action'] )
					&& 'automation' === $_GET['action']
					)
				) {

					wp_enqueue_script( 'cp-suretriggers-integration', 'https://app.suretriggers.com/js/v2/embed.js', array(), CP_V2_VERSION, true );

					wp_register_script( 'cp-automation', CP_AUTOMATION_BASE_URL . 'assets/cp-automation.js', array( 'jquery' ), time(), true );
					wp_enqueue_script( 'cp-automation' );

					wp_enqueue_style( 'css-automation', CP_AUTOMATION_BASE_URL . 'assets/cp-automation.css', array(), CP_V2_VERSION );

					$is_suretrigger_connected = apply_filters( 'suretriggers_is_user_connected', '' );

					wp_localize_script(
						'cp-automation',
						'CP_Integrations',
						array(
							'ajax_url'                 => admin_url( 'admin-ajax.php' ),
							'integration_text'         => __( 'Configure Integration', 'convertpro-addon' ),
							'install_text'             => __( 'Install & Activate', 'convertpro-addon' ),
							'installing_text'          => __( 'Installing...', 'convertpro-addon' ),
							'connecting_text'          => __( 'Connecting...', 'convertpro-addon' ),
							'activate_text'            => __( 'Activate', 'convertpro-addon' ),
							'activating_text'          => __( 'Activating...', 'convertpro-addon' ),
							'connect_text'             => __( 'Connect with SureTriggers', 'convertpro-addon' ),
							'connected_text'           => __( 'Connected', 'convertpro-addon' ),
							'integration_url'          => admin_url( 'admin.php?page=convert-pro-automation' ),
							'suretriggers_url'         => admin_url( 'admin.php?page=suretriggers' ),
							'is_suretrigger_connected' => $is_suretrigger_connected,
							'nonce'                    => wp_create_nonce( 'cp_suretriggers' ),
							'activation_failed'        => __( 'Activation failed. Please try again.', 'convertpro-addon' ),
							'installation_failed'      => __( 'Installation failed. Please try again.', 'convertpro-addon' ),
						)
					);
			}
		}

		/**
		 * Define constants.
		 *
		 * @since x.x.x
		 * @return void
		 */
		private function define_constants() {

			define( 'CP_AUTOMATION_BASE_DIR', CP_ADDON_DIR . 'addons/automation/' );
			define( 'CP_AUTOMATION_BASE_URL', CP_ADDON_URL . 'addons/automation/' );
		}

		/**
		 * Loads classes and includes.
		 *
		 * @since x.x.x
		 * @return void
		 */
		private static function load_files() {
			/* Classes */
			require_once CP_AUTOMATION_BASE_DIR . 'class-cp-automation-handler.php';
		}
	}

	$automation_loader = CPRO_Automation_Loader::get_instance();
}
