<?php

namespace WPML\PHP\Logger;

use Psr\Log\LoggerInterface;

class LogLoader {

  /** @var LoggerInterface|null */
  private static $logger;


  /**
   * @param LoggerInterface $logger
   *
   * @return void
   */
  public static function load( LoggerInterface $logger ) {
    self::$logger = $logger;
  }


  public static function getLogger(): \Psr\Log\LoggerInterface {
    if ( ! self::$logger ) {
      self::$logger = new NullLogger();
    }

    return self::$logger;
  }


}
