<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

function naga_astra_php_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'According to %1$s the PHP version of your host must be at least {%2$s} or higher! Please update your host PHP version to be able to activate %3$s and use the pro version. %4$s', 'naga-astra-notices' ),
				
				'<a href="https://wordpress.org/about/requirements/" target="_blank" rel="noopener noreferrer">'.__('WordPress Requirements', 'naga-astra-notices').'</a>',

				naga_astra_min_reqiered_php,
				
				wp_get_theme()->name,
				
				'<a href="https://nagatheme.com/how-to-change-host-php-version/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-astra-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

function naga_astra_ioncube_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'Unfortunately, %1$s settings are Disabled! The Product PHP files are encrypted for more performance and security! ionCube Loader is required to be installed in your host! Please contact your hosting support and ask them to install the ioncube loader! %2$s', 'naga-astra-notices' ),
				
				wp_get_theme()->name,
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-astra-notices').'</a>'
				
				);
			?>
		</p>
	</div>
	
	<?php
}

function naga_astra_ioncube_version_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			
			echo sprintf(
			
				__( 'Unfortunately, %1$s settings are Disabled! The Product PHP files are encrypted for more performance and security by ioncube! The ioncube loader is active in your host but its version is {%2$s} while it must be at least {%3$s} so that you can use this product. Please contact your hosting support and ask them to update the ioncube loader! %4$s', 'naga-astra-notices' ),
				
				wp_get_theme()->name,
				
				naga_astra_get_ioncube_loader_version(),

				naga_astra_min_reqiered_ioncube,
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-astra-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

function naga_astra_get_ioncube_loader_version() {
	
	if( function_exists( 'ioncube_loader_version' ) ) {
		
		$ioncube_loader_version = ioncube_loader_version();
		
		return $ioncube_loader_version;
		
	} else {
		
		return __( 'NAN', 'naga-astra-notices' );
		
	}
	
}

function naga_astra_pro_deactivate_licenses() {
	
	// Activate All Premium Product Licenses
	$brainstrom = get_option( 'brainstrom_products' );
	
	$brainstrom['plugins']['astra-addon']['status'] = 'deactivated';
	
	$brainstrom['plugins']['astra-pro-sites']['status'] = 'deactivated';
	
	$brainstrom['plugins']['uael']['status'] = 'deactivated';
	
	$brainstrom['plugins']['uabb']['status'] = 'deactivated';
	
	$brainstrom['plugins']['convertpro']['status'] = 'deactivated';
	
	$brainstrom['plugins']['wp-schema-pro']['status'] = 'deactivated';
	
	$brainstrom['plugins']['astra-portfolio']['status'] = 'deactivated';
	
	update_option( 'brainstrom_products', $brainstrom );
	
	remove_submenu_page( 'astra', 'astra' );

	remove_submenu_page( 'astra', 'customize.php' );
	
	remove_submenu_page( 'astra', 'starter-templates' );
			
	remove_submenu_page( 'astra', 'edit.php?post_type=astra_adv_header' );
	
	remove_submenu_page( 'astra', 'edit.php?post_type=astra-advanced-hook' );
	
	remove_submenu_page( 'astra', 'admin.php?page=astra&path=custom-layouts' );
	
	remove_submenu_page( 'astra', 'edit.php?post_type=bsf-sidebar' );
	
	remove_submenu_page( 'astra', 'edit-tags.php?taxonomy=bsf_custom_fonts' );
	
	remove_submenu_page( 'astra', 'naga-astra-kb' );

}