<?php
define( 'naga_astra_min_reqiered_php', '7.4' ); // without dot (not 7.4.0)
define( 'naga_astra_min_reqiered_ioncube', '12' ); // without dot (not 12.0.0)

add_action( 'init', function() {
	load_textdomain( 'naga-astra-notices', get_stylesheet_directory() . '/languages/' . 'naga-astra-notices-fa_IR.mo' );
});

require_once( get_stylesheet_directory() . '/includes/naga-astra-notices.php' );

// Load NagaTheme License, RTL and Persian Files
if( version_compare( PHP_VERSION, naga_astra_min_reqiered_php ) >= 0 ) {
	
	if( extension_loaded( 'ionCube Loader' ) ) {
		
		if( function_exists( 'ioncube_loader_version' ) && version_compare( ioncube_loader_version(), naga_astra_min_reqiered_ioncube ) >= 0 ) { // without dot (not 11.0.0)
			
			require_once( get_stylesheet_directory() . '/functions-ic.php' );
			
		} else {
			
			add_action( 'admin_notices', 'naga_astra_ioncube_version_notice' );
			add_action( 'admin_init', 'naga_astra_pro_deactivate_licenses' );
			
		}
			
	} else {
		
		add_action( 'admin_notices', 'naga_astra_ioncube_notice' );
		add_action( 'admin_init', 'naga_astra_pro_deactivate_licenses' );
		
	}
} else {
	
	add_action( 'admin_notices', 'naga_astra_php_notice' );
	add_action( 'admin_init', 'naga_astra_pro_deactivate_licenses' );

}