<?php
/*
Plugin Name: register login addon - user panel pro
Plugin URI: https://webiha.com
Description: Designed for enhance the login and registration capabilities in the user panel pro plugin
Version: 8.6.3
Author: Webiha
Author URI: https://webiha.com
Text Domain: user-panel-pro
Domain Path: /languages/
Requires at least: 5.0
Requires PHP:7.1
*/

defined('ABSPATH') || die('No Access');

/**
 * WUPP_User_Panel_Pro class.
 *
 * @class The class that holds the entire plugin.
 */
final class WUPP_User_Panel_Pro
{

    /**
     * Plugin version
     *
     * @var string
     */
    public $version = '8.6.3';

    /**
     * Minimum version of Base User Panel Plugin.
     *
     * @var string
     */
    public $user_panel_min_version = '8.6.0';

    /**
     * Holds messages.
     *
     * @var array
     */
    private $messages = [];

    /**
     * Slug for the free version of the plugin.
     *
     * @var string
     */
    private $free_version_plugin_path = 'user-panel-pro/user-panel-pro.php';
    /**
     * The single instance of the class
     *
     * @var WUPP_User_Panel_Pro
     */
    protected static $instance = null;

    /**
     * Get class single instance
     * @return null|WUPP_User_Panel_Pro
     */
    public static function get_instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Class constructor.
     */
    private function __construct()
    {
        if (!$this->are_requirements_met()) {
            return;
        }
        $this->define_constants();
        add_action('user-panel/loaded', [$this, 'setup']);
        add_action('plugins_loaded', [$this, 'localization_setup']);
    }

    /**
     * Instantiate the plugin.
     */
    public function setup()
    {
//        if (!$this->is_free_version_compatible()) {
//            $this->messages[] = esc_html__('Please update User Panel Base to the latest version first before activating the PRO version.', 'user-panel-pro');
//            add_action('admin_notices', [$this, 'activation_error']);
//            return false;
//        }
        $this->includes();
    }

    /**
     * Is free version compatible.
     *
     * @return bool
     */
    public function is_free_version_compatible()
    {
        return defined('USER_PANEL_VERSION') && version_compare(USER_PANEL_VERSION, $this->user_panel_min_version, '>=');
    }

    /**
     * Check that the WordPress and PHP setup meets the plugin requirements.
     *
     * @return bool
     */
    private function are_requirements_met()
    {
        $dont_load = false;
        if (!$this->is_free_version_activated()) {
            // Todo: this message is not displayed because of a redirect.
            $this->messages[] = esc_html__('User Panel free version is required to run User Panel Pro. Both plugins are now disabled.', 'user-panel-pro');
        } elseif ($this->is_free_version_being_rolled_back() || $this->is_free_version_being_updated() || $this->is_troubleshooting()) {
            $dont_load = true;
        } else {
            if (!$this->is_free_version_installed()) {
                // if ( ! $this->install_free_version() ) {
                $this->messages[] = esc_html__('User Panel free version is required to run User Panel Pro, but it could not be installed automatically. Please install and activate the free version first.', 'user-panel-pro');
                // }
            }

            if (!$this->is_free_version_activated()) {
                if (!$this->activate_free_version()) {
                    $this->messages[] = esc_html__('User Panel free version is required to run User Panel Pro, but it could not be activated automatically. Please install and activate the free version first.', 'user-panel-pro');
                }
            }
        }

        if ($dont_load) {
            return false;
        }

        if (empty($this->messages)) {
            return true;
        }

        // Auto-deactivate plugin.
        add_action('admin_init', [$this, 'auto_deactivate']);
        add_action('admin_notices', [$this, 'activation_error']);
        return false;
    }

    /**
     * Check if troubleshooting mode is enabled in Health Check plugin and if User Panel Free version is not.
     *
     * @return boolean
     */
    public function is_troubleshooting()
    {
        return (bool)get_option('health-check-allowed-plugins') && !$this->is_free_version_activated();
    }

    /**
     * Check if rollback is in progress, so that Pro doesn't get deactivated.
     *
     * @return boolean
     */
    public function is_free_version_being_rolled_back()
    {
        // return class_exists( 'WUPP_User_Panel' ) && WUPP_User_Panel()->version != get_option( 'wupp_version' );
    }

    /**
     * Auto-deactivate plugin if requirement not met and display a notice.
     */
    public function auto_deactivate()
    {
        deactivate_plugins(plugin_basename(__FILE__));
        // phpcs:disable
        if (isset($_GET['activate'])) {
            unset($_GET['activate']);
        }
        // phpcs:enable
    }

    /**
     * Plugin activation notice.
     */
    public function activation_error()
    {
        ?>
        <div class="user-panel-notice notice notice-error">
            <p>
                <?php echo join('<br>', $this->messages); // phpcs:ignore
                ?>
            </p>
        </div>
        <?php
    }

    /**
     * Define the plugin constants.
     */
    private function define_constants()
    {
        define('USER_PANEL_PRO_VERSION', $this->version);
        define('USER_PANEL_PRO_FILE', __FILE__);
        define('USER_PANEL_PRO_PATH', dirname(USER_PANEL_PRO_FILE) . '/');
        define('USER_PANEL_PRO_URL', plugins_url('', USER_PANEL_PRO_FILE) . '/');
    }

    /**
     * Include the required files.
     */
    private function includes()
    {
        if (class_exists('WUPP_User_Panel')) {
            include 'source.php';
            include WUPP_RL_LIBS . 'vendor/autoload.php';
            add_filter('wupp_autoload_files', 'handel_autoload_files', 10, 2);
            function handel_autoload_files(array $files, string $class)
            {
                $class = strtolower($class);
                $files[] = WUPP_RL_CLASSES . 'class-' . $class . '.php';
                $files[] = WUPP_RL_GATEWAYS . (str_replace('wupp', '', $class)) . '/class-' . $class . '.php';

                return $files;
            }

            if (is_admin()) {
                include_once WUPP_RL_INCS . 'updator.php';
            }
            new WUPPRLHandler;
        };
    }

    /**
     * Initialize plugin for localization.
     *
     * Note: the first-loaded translation file overrides any following ones if the same translation is present.
     *
     */
    public function localization_setup()
    {
        load_plugin_textdomain('user-panel-pro', false, basename(dirname(__FILE__)) . '/languages');
    }

    /**
     * Check User Panel plugin is installed on the site.
     *
     * @return boolean Whether it's installed or not.
     */
    public function is_free_version_installed()
    {
        // First check if active, because that is less costly.
        if ($this->is_free_version_activated()) {
            return true;
        }

        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $installed_plugins = get_plugins();

        return array_key_exists($this->free_version_plugin_path, $installed_plugins);
    }

    /**
     * Install User Panel free version from the wordpress.org repository.
     *
     * @return bool Whether install was successful.
     */
    public function install_free_version()
    {
        include_once ABSPATH . 'wp-includes/pluggable.php';
        include_once ABSPATH . 'wp-admin/includes/misc.php';
        include_once ABSPATH . 'wp-admin/includes/file.php';
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
        include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
        $skin = new Automatic_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader($skin);
        $plugin_file = 'https://downloads.wordpress.org/plugin/user-panel.latest-stable.zip';
        $result = $upgrader->install($plugin_file);

        return $result;
    }

    /**
     * Check User Panel plugin is activated on the site.
     *
     * @return boolean Whether it's active or not.
     */
    public function is_free_version_activated()
    {
        $active_plugins = get_option('active_plugins', []);
        return in_array($this->free_version_plugin_path, $active_plugins, true);
    }

    /**
     * Checks if WP is in the process of updating the free one.
     *
     * @return boolean Whether we are in the process of updating the plugin or not.
     */
    public function is_free_version_being_updated()
    {
        $action = isset($_POST['action']) && $_POST['action'] != -1 ? $_POST['action'] : '';
        $plugins = isset($_POST['plugin']) ? (array)$_POST['plugin'] : [];
        if (empty($plugins)) {
            $plugins = isset($_POST['plugins']) ? (array)$_POST['plugins'] : [];
        }

        $update_plugin = 'update-plugin';
        $update_selected = 'update-selected';
        $actions = [$update_plugin, $update_selected];

        if (!in_array($action, $actions, true)) {
            return false;
        }

        return in_array($this->free_version_plugin_path, $plugins, true);
    }

    /**
     * Checks if WP is in the process of deactivating the free one.
     *
     * @return boolean Whether we are in the process of deactivating the plugin or not.
     */
    public function is_free_version_being_deactivated()
    {
        if (!is_admin()) {
            return false;
        }

        $action = isset($_REQUEST['action']) && $_REQUEST['action'] != -1 ? $_REQUEST['action'] : '';
        if (!$action) {
            $action = isset($_REQUEST['action2']) && $_REQUEST['action2'] != -1 ? $_REQUEST['action2'] : '';
        }
        $plugin = isset($_REQUEST['plugin']) ? $_REQUEST['plugin'] : '';
        $checked = isset($_POST['checked']) && is_array($_POST['checked']) ? $_POST['checked'] : [];

        $deactivate = 'deactivate';
        $deactivate_selected = 'deactivate-selected';
        $actions = [$deactivate, $deactivate_selected];

        if (!in_array($action, $actions, true)) {
            return false;
        }

        if ($action === $deactivate && $plugin !== $this->free_version_plugin_path) {
            return false;
        }

        if ($action === $deactivate_selected && !in_array($this->free_version_plugin_path, $checked, true)) {
            return false;
        }

        return true;
    }

    /**
     * Activate User Panel free version.
     *
     * @return bool Whether activation was successful or not.
     */
    public function activate_free_version()
    {
        return activate_plugin($this->free_version_plugin_path);
    }
}

WUPP_User_Panel_Pro::get_instance();