<?php
defined('ABSPATH') || die('No Access');
$user_info = wp_get_current_user();
$type = WUPPTools::wupp_get_register_form_type_function();
?>
<!-- account setting page -->
<section id="page-account-settings">
    <div class="row">
        <!-- left menu section -->
        <div class="col-md-3 mb-2 mb-md-0">
            <ul class="nav nav-pills flex-column nav-left">
                <!-- general -->
                <li class="nav-item">
                    <a class="nav-link active" id="account-pill-general" data-toggle="pill" href="#account-vertical-general" aria-expanded="true">
                        <i data-feather="user" class="font-medium-3 mr-1"></i>
                        <span class="font-weight-bold"><?= __('Account General', 'user-panel-pro'); ?></span>
                    </a>
                </li>
                <!-- change password -->
                <li class="nav-item">
                    <a class="nav-link" id="account-pill-password" data-toggle="pill" href="#account-vertical-password" aria-expanded="false">
                        <i data-feather="lock" class="font-medium-3 mr-1"></i>
                        <span class="font-weight-bold"><?= __('Change Password', 'user-panel-pro'); ?></span>
                    </a>
                </li>
                <!-- information -->
                <?php if (!is_null($type) && !empty($type)) : ?>
                    <li class="nav-item">
                        <a class="nav-link" id="account-pill-info" data-toggle="pill" href="#account-vertical-info" aria-expanded="false">
                            <i data-feather="info" class="font-medium-3 mr-1"></i>
                            <span class="font-weight-bold"><?= __('Information', 'user-panel-pro'); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
        <!--/ left menu section -->

        <!-- right content section -->
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <div class="tab-content">
                        <!-- general tab -->
                        <div role="tabpanel" class="tab-pane active" id="account-vertical-general" aria-labelledby="account-pill-general" aria-expanded="true">
                            <!-- header media -->
                            <div class="media">
                                <a href="javascript:void(0);" class="mr-25">
                                    <img src="<?= WUPPUsers::get_avatar($user_info->ID); ?>" id="account-upload-img" class="rounded mr-50" alt="profile image" height="80" width="80" />
                                </a>
                                <?php if (WUPPAdminViews::get_option('pro_panel_accept_upload_avatar', '0')) : ?>
                                    <?php
                                    $restrict_roles = is_array(WUPPAdminViews::get_option('pro_restrict_upload_avatar_rol', '')) ? WUPPAdminViews::get_option('pro_restrict_upload_avatar_rol', '') : [];
                                    if (!in_array($user_info->roles[0], $restrict_roles)) : ?>
                                        <!-- upload and reset button -->
                                        <div class="media-body mt-75 ml-1">
                                            <label for="account-upload" class="btn btn-sm btn-primary mb-75 mr-75"><?= __('Change avatar', 'user-panel-pro'); ?></label>
                                            <input type="file" id="account-upload" hidden accept="image/png, image/jpeg, image/jpg" />
                                            <input type="text" name="upload-avatar-data" hidden data-url="<?= admin_url('admin-ajax.php'); ?>">
                                            <!-- <button class="btn btn-sm btn-outline-secondary mb-75">Reset</button> -->
                                            <p><?= __('Allowed JPG, JPEG or PNG. Max size of ', 'user-panel-pro') . WUPPAdminViews::get_option('pro_panel_upload_avatar_size_limit', '0.9') . ' MB'; ?></p>
                                        </div>
                                        <!--/ upload and reset button -->
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <!--/ header media -->

                            <!-- form -->
                            <form class="validate-form mt-2" id="wupp-edit-account-general" method="POST" action="<?= admin_url('admin-ajax.php'); ?>">
                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-username"><?= __('Username', 'user-panel-pro'); ?></label>
                                            <input type="text" class="form-control" id="account-username" name="username" placeholder="<?= __('Username', 'user-panel-pro'); ?>" value="<?= $user_info->user_login; ?>" readonly />
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-name"><?= __('Display name', 'user-panel-pro'); ?></label>
                                            <input type="text" class="form-control" id="account-name" name="display_name" placeholder="Name" value="<?= $user_info->display_name; ?>" required />
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-e-mail"><?= __('E-mail', 'user-panel-pro'); ?></label>
                                            <input type="email" class="form-control <?= get_user_meta($user_info->ID, 'wupp_account_email_status', true) ? 'is-valid' : 'is-invalid'; ?>" id="account-e-mail" name="email" placeholder="<?= __('Email', 'user-panel-pro'); ?>" value="<?= $user_info->user_email; ?>" required />
                                            <div class="valid-feedback"><?= __('Your email has been verified', 'user-panel-pro'); ?></div>
                                            <div class="invalid-feedback"><?= __('Your email has not been verified', 'user-panel-pro'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-phone"><?= __('Phone number', 'user-panel-pro'); ?></label>
                                            <input type="text" class="form-control <?= get_user_meta($user_info->ID, 'wupp_account_phone_status', true) ? 'is-valid' : 'is-invalid'; ?> " id="account-phone" name="phone_number" placeholder="<?= __('Phone', 'user-panel-pro'); ?>" value="<?= get_user_meta($user_info->ID, 'wupp_mobile', true) ?>" required />
                                            <div class="valid-feedback"><?= __('Your phone number has been verified', 'user-panel-pro'); ?></div>
                                            <div class="invalid-feedback"><?= __('Your phone number has not been verified', 'user-panel-pro'); ?></div>
                                        </div>
                                    </div>
                                    <?php if (WUPPAdminViews::get_option('pro_verify_mobile_in_panel', '') && !get_user_meta($user_info->ID, 'wupp_account_phone_status', true)) : ?>
                                        <div class="col-12 mt-75">
                                            <div class="alert alert-warning mb-50" role="alert">
                                                <h4 class="alert-heading"><?= __('Your phone number is not confirmed, Please confirm it via the link below.', 'user-panel-pro'); ?></h4>
                                                <div class="alert-body">
                                                    <a href="javascript: void(0);" class="alert-link" onclick="verify_phone_panel()"><?= __('Verify my number', 'user-panel-pro'); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (WUPPAdminViews::get_option('pro_verify_email_in_panel', '') && !get_user_meta($user_info->ID, 'wupp_account_email_status', true)) : ?>
                                        <div class="col-12 mt-75">
                                            <div class="alert alert-warning mb-50" role="alert">
                                                <h4 class="alert-heading"><?= __('Your Email is not confirmed, Please confirm it via the link below.', 'user-panel-pro'); ?></h4>
                                                <div class="alert-body">
                                                    <a href="javascript: void(0);" class="alert-link" onclick="verify_email_panel()"><?= __('Verify my Email', 'user-panel-pro'); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mt-2 mr-1 btn-form-block-overlay waves-effect"><?= __('Save changes', 'user-panel-pro'); ?></button>
                                    </div>
                                </div>
                            </form>
                            <!--/ form -->
                        </div>
                        <!--/ general tab -->

                        <!-- change password -->
                        <div class="tab-pane fade" id="account-vertical-password" role="tabpanel" aria-labelledby="account-pill-password" aria-expanded="false">
                            <!-- form -->
                            <form class="validate-form" id="wupp-edit-account-password" method="POST" action="<?= admin_url('admin-ajax.php'); ?>">
                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-old-password"><?= __('Old Password', 'user-panel-pro'); ?></label>
                                            <div class="input-group form-password-toggle input-group-merge">
                                                <input type="password" class="form-control" id="account-old-password" name="password" placeholder="<?= __('Old Password', 'user-panel-pro'); ?>" required />
                                                <div class="input-group-append">
                                                    <div class="input-group-text cursor-pointer">
                                                        <i data-feather="eye"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-new-password"><?= __('New Password', 'user-panel-pro'); ?></label>
                                            <div class="input-group form-password-toggle input-group-merge">
                                                <input type="password" id="account-new-password" name="new-password" class="form-control" placeholder="<?= __('New Password', 'user-panel-pro'); ?>" required />
                                                <div class="input-group-append">
                                                    <div class="input-group-text cursor-pointer">
                                                        <i data-feather="eye"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-retype-new-password"><?= __('Retype New Password', 'user-panel-pro'); ?></label>
                                            <div class="input-group form-password-toggle input-group-merge">
                                                <input type="password" class="form-control" id="account-retype-new-password" name="confirm-new-password" placeholder="<?= __('New Password', 'user-panel-pro'); ?>" required />
                                                <div class="input-group-append">
                                                    <div class="input-group-text cursor-pointer"><i data-feather="eye"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mr-1 mt-1"><?= __('Save changes', 'user-panel-pro'); ?></button>
                                    </div>
                                </div>
                            </form>
                            <!--/ form -->
                        </div>
                        <!--/ change password -->

                        <!-- information -->
                        <div class="tab-pane fade" id="account-vertical-info" role="tabpanel" aria-labelledby="account-pill-info" aria-expanded="false">
                            <!-- form -->
                            <?php if (!is_null($type) && !empty($type)) : ?>
                                <form class="validate-form" method="POST" id="wupp_edit_profile_form">
                                    <?php echo call_user_func($type); ?>
                                    <div class="col-12">
                                        <button type="submit" id="wupp_update_profile" class="btn btn-primary mt-1 mr-1" data-url="<?php echo admin_url('admin-ajax.php'); ?>"><?= __('Save changes', 'user-panel-pro'); ?></button>
                                    </div>
                                </form>
                            <?php endif; ?>
                            <!--/ form -->
                        </div>
                        <!--/ information -->

                    </div>
                </div>
            </div>
        </div>
        <!--/ right content section -->
    </div>
</section>
<!-- / account setting page -->