<?php

/**
 * User Panel Pro plugin new login
 *
 */
defined('ABSPATH') || exit;
//all options for login page.
$login_settings = WUPPAdminViews::get_options();
$is_restore_link = WUPPTools::is_restore_request();
$register_page_allow = $login_settings['register_permission'];
$forget_page_allow = $login_settings['forget_permission'];
do_action('wupp_start_login_page');
?>
    <link rel="stylesheet" href="<?php echo WUPP_ASSETS_CSS . 'setting.features.css' ?>">
<?php WUPPAsset::wupp_enqueue_scripts_styles('login'); ?>
    <script type="text/javascript" src="<?php echo WUPP_ASSETS_JS . 'wupp-login.js' ?>"></script>
    <link rel="stylesheet" href="<?php echo WUPP_RL_CSS . 'style-V2.css' ?>">
<?php if (WUPPAsset::wupp_is_rtl_local()) : ?>
    <link rel="stylesheet" href="<?php echo WUPP_RL_CSS . 'style-V2-rtl.css' ?>">
<?php endif; ?>
<?php include WUPP_RL_TPL . 'login-V2/assets/login-style.php'; ?>
    <div id="container" class="col-12">
        <div id="forms" class="wupp
    position-relative
	container-fluid
	col-12
	col-sm-10
	col-md-10
	d-flex
	flex-wrap
    justify-content-lg-around
    justify-content-md-around
	justify-content-sm-center
	align-items-center
	overflow-hidden
	mt-5
	rounded
	">
            <div id="options"
                 class="position-absolute d-flex justify-content-around justify-content-sm-start p-0 p-md-1 col-12 col-sm-12 col-md-12 col-lg-11">
                <?php
                if ($login_settings['show_login_back_btn_V2']) : ?>
                    <div id="returnHome"
                         class="pl-2 col-7 col-md-6 position-relative d-flex align-items-center justify-content-start">
                        <a href="<?php echo site_url(); ?>">
                            <svg id="arrowHome" width="22" height="24" viewBox="0 0 24 24" fill="none"
                                 stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"
                                 class="feather feather-arrow-left">
                                <line x1="19" y1="12" x2="5" y2="12">
                                </line>
                                <polyline points="12 19 5 12 12 5">
                                </polyline>
                            </svg>
                            <?php echo __('Back To Home Screen', 'user-panel-pro'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div id="darkModeContainer" class="position-relative align-items-center justify-content-between d-none">
                    <label for="darkMode" id="day" class="mx-1">
                        <svg class="sun" width="19" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                             stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="5">
                            </circle>
                            <line x1="12" y1="1" x2="12" y2="3">
                            </line>
                            <line x1="12" y1="21" x2="12" y2="23">
                            </line>
                            <line x1="4.22" y1="4.22" x2="5.64" y2="5.64">
                            </line>
                            <line x1="18.36" y1="18.36" x2="19.78" y2="19.78">
                            </line>
                            <line x1="1" y1="12" x2="3" y2="12">
                            </line>
                            <line x1="21" y1="12" x2="23" y2="12">
                            </line>
                            <line x1="4.22" y1="19.78" x2="5.64" y2="18.36">
                            </line>
                            <line x1="18.36" y1="5.64" x2="19.78" y2="4.22">
                            </line>
                        </svg>
                    </label>

                    <input type="checkbox" id="darkMode" class="mx-2 mb-2"/>

                    <label for="darkMode" id="night" class="mx-1">
                        <svg class="moon moonOff" width="19" height="19" viewBox="0 0 24 24" fill="none"
                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z">
                            </path>
                        </svg>
                    </label>
                </div>
            </div>
            <svg id="leftLgCircle" class=" svgs d-xl-block d-lg-block d-md-none d-sm-none d-none position-absolute">
                <circle cx="20" cy="660" r="130"/>
            </svg>
            <svg id="RightLgCircle" class=" svgs d-xl-block d-lg-block d-md-none d-sm-none d-none position-absolute">
                <circle cx="250" cy="100" r="290"/>
            </svg>
            <svg id="leftMdCircle" class="svgs d-xl-none d-lg-none d-md-block d-sm-block position-absolute">
                <circle cx="0" cy="600" r="100"/>
            </svg>
            <svg id="RightMdCircle" class="svgs d-xl-none d-lg-none d-md-block d-sm-block position-absolute">
                <circle cx="235" cy="-190" r="220"/>
            </svg>
            <?php $is_default = false; ?>
            <?php include_once WUPP_RL_INCS . 'templates/login-V2/__side.php' ?>
            <?php include_once WUPP_RL_INCS . 'templates/login-V2/__sign_in.php' ?>
            <?php if ($register_page_allow) : ?>
                <?php include_once WUPP_RL_INCS . 'templates/login-V2/__register.php' ?>
            <?php endif; ?>
            <?php if ($forget_page_allow) : ?>
                <?php include_once WUPP_RL_INCS . 'templates/login-V2/__forget.php' ?>
            <?php endif; ?>
            <!--        include auth code section for login part-->
            <?php
            $pre_message = __('To enter, enter the verification code sent in this section!', 'user-panel-pro');
            $pre_connect = 'sign_in_';
            $pre_id = 'login';
            include WUPP_RL_INCS . 'templates/login-V2/__auth_code.php';
            ?>
            <!--        include auth code sction for register part-->
            <?php
            $pre_message = __('To complete the registration, you must enter the verification code sent to you!', 'user-panel-pro');
            $pre_connect = 'register_';
            $pre_id = 'register';
            include WUPP_RL_INCS . 'templates/login-V2/__auth_code.php';
            ?>
            <!--        include auth ocde section for forget part-->
            <?php
            $pre_message = __('Enter the verification code to change the password!', 'user-panel-pro');
            $pre_connect = 'forget_';
            $pre_id = 'forget';
            include WUPP_RL_INCS . 'templates/login-V2/__auth_code.php';
            ?>
        </div>
    </div>
    <script src="<?php echo WUPP_RL_JS . 'app.js' ?>"></script>
    <script type="text/javascript" src="<?php echo WUPP_ASSETS_JS . 'login-global.js' ?>"></script>
    <!-- TODO  -->
    <!-- process codes start -->
    <script data-role="wupp">
        const loadingTag = '<span class="spinner-border spinner-border-sm" role="status"></span>'
        <?php if ($is_default != true) : ?>
        $(document).ready(function () {
            $("#wupp_sign_in_btn").on("click", function (e) {
                e.preventDefault();
                sign_in($(this), false)
            });
            $("#wupp_sign_in_code_btn").on("click", function (e) {
                e.preventDefault();
                sign_in($(this), true)
            });
        });
        function sign_in(btn, id_main) {
            jQuery('#signinFormState').addClass('d-none');
            var btn_title = jQuery(btn).html();
            var form = jQuery('#form_sign_in');
            var data = [];
            if (id_main !== undefined && id_main === true) {
                var vv = jQuery(jQuery(form).find("input[name='user_login']")[0]).val();
                vv = convert_number.toNormal(vv);
                id_main = vv !== undefined && vv !== '';
                data.push({
                    name: 'user_login',
                    value: vv
                });
                data.push({
                    name: 'action',
                    value: 'wupp_sign_in'
                });
            } else {
                data = jQuery(form).serializeArray();
                // check persian and arabic numbers
                data.push({
                    name: 'action',
                    value: 'wupp_sign_in'
                });
                data = $.each(data, function (i, field) {
                    field.value = convert_number.toNormal(field.value);
                });
            }
            if (!id_main) {
                jQuery(form).find('input').each(function () {
                    var name = jQuery(this).attr('name');
                    if (jQuery(this).val() === '' && name !== 'token') {
                        data = false;
                    }
                });
            }
            if (data || id_main) {
                jQuery(btn)
                    .addClass('disabled')
                    .attr('disabled', 'disabled')
                    .html(loadingTag);
                $.ajax({
                    data: data,
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    complete: function () {
                        jQuery(btn)
                            .removeClass('disabled')
                            .removeAttr('disabled', 'disabled')
                            .html(btn_title);
                    },
                    success: function (response) {
                        if (response.result === 2) {
                            const queryString = window.location.search;
                            const urlParams = new URLSearchParams(queryString);
                            const redirect = urlParams.get('redirect_to')
                            if (redirect) {
                                location.replace(redirect);
                            } else
                                location.replace(response.redirect_url);
                        } else if (response.result === 1) {
                            jQuery('#wupp_sign_in_auth_pnl').removeClass('d-none');
                            show_auth_login();
                            jQuery('#sign_in_auth_helper').val(response.auth_helper);
                            if (response.auth_type !== undefined && response.auth_type !== null && response.auth_type !== '') {
                                jQuery('#sign_in_auth_type').val(response.auth_type);
                            }
                            start_auth_time(jQuery('#sign_in_wupp_try_new_code'));
                        } else if (response.result === 3) {
                            jQuery('#signinFormState').html(response.view).removeClass('d-none');
                        }  else if (response.result === 4) {
                            jQuery('#signinFormState')
                                .html('<?php echo __('Account not found, register if you do not have an account', 'user-panel-pro'); ?><button class="btn btn-link text-decoration-none" onclick="load_sign_up()"><ins><?php _e('sign up', 'user-panel-pro'); ?></ins></button>')
                                .addClass('alert-danger')
                                .removeClass('d-none');
                        } else {
                            jQuery('#signinFormState')
                                .html(response.message)
                                .removeClass('d-none');
                        }
                    },
                    error: function (e) {
                    }
                });
            } else {
                jQuery('#signinFormState')
                    .html('<?php echo __('Complete form!', 'user-panel-pro'); ?>')
                    .removeClass('d-none');
            }
        }

        <?php endif; ?>

        jQuery(document).ready(function () {
            jQuery('#um_default_css-inline-css').remove();
            jQuery('#form_sign_up').on('submit', function (e) {
                e.preventDefault();
                jQuery('#signupFormState').addClass('d-none');
                var sign_up_allow = true;
                var password = '';
                jQuery(this).find("input").each(function () {
                    var required = jQuery(this).attr('data-required');
                    var value = jQuery(this).val();

                    if (required && required === 'required' && !value) {
                        sign_up_allow = false;
                        jQuery(this).parent().addClass('fillBeforeDanger');
                        jQuery('#signupFormState')
                            .html('<?php echo __('Fill in the star fields', 'user-panel-pro') ?>')
                            .removeClass('d-none');
                    } else {
                        jQuery(this).removeClass('fillBeforeDanger');
                    }

                    if (jQuery(this).attr('name') === 'password') {
                        password = jQuery(this).val();
                    } else if (jQuery(this).attr('name') === 'password_repeat') {
                        if (password !== jQuery(this).val()) {
                            sign_up_allow = false;
                            jQuery(this).parent().addClass('fillBeforeDanger');
                            jQuery('#signupFormState')
                                .html('<?php echo __('Passwords is wrong') ?>')
                                .removeClass('d-none');
                        }
                    }
                });

                if (sign_up_allow) {
                    var btn = jQuery('#btn_sub_sign_up');
                    if (jQuery('#check_box_wupp_remember_me').is(':checked')) {
                        var data = jQuery(this).serializeArray();
                        data.push({
                            name: 'action',
                            value: 'wupp_sign_up'
                        });
                        jQuery(btn)
                            .addClass('disabled')
                            .attr('disabled', 'disabled')
                            .html(loadingTag);
                        $.ajax({
                            data: data,
                            type: 'POST',
                            url: '<?php echo admin_url('admin-ajax.php'); ?>',
                            complete: function () {
                                jQuery(btn)
                                    .removeClass('disabled')
                                    .removeAttr('disabled', 'disabled')
                                    .html('<?php echo __("Register", "user-panel-pro") ?>');
                            },
                            success: function (response) {
                                if (response.result === 2) {
                                    const queryString = window.location.search;
                                    const urlParams = new URLSearchParams(queryString);
                                    const redirect = urlParams.get('redirect_to')
                                    if (redirect) {
                                        location.replace(redirect);
                                    } else
                                        location.replace(response.redirect_url);
                                } else if (response.result === 1) {
                                    jQuery('#sign_up_auth').removeClass('d-none');
                                    show_auth_register();
                                    jQuery('#register_auth_helper').val(response.auth_helper);
                                    jQuery('#register_auth_type').val(response.auth_type);
                                    start_auth_time(jQuery('#register_wupp_try_new_code'));
                                } else {
                                    jQuery('#signupFormState')
                                        .html(response.message)
                                        .removeClass('d-none');
                                }
                            },
                            error: function (e) {
                                jQuery('#signupFormState')
                                    .html('<?php echo __('No internet connection!', 'user-panel-pro') ?>')
                                    .removeClass('d-none');
                            }
                        });
                    } else {
                        jQuery('#signupFormState')
                            .html('<?php echo __('accept the rules', 'user-panel-pro'); ?>')
                            .removeClass('d-none');
                    }
                }
            });
            jQuery('#form_sign_in').on('submit', function (e) {
                e.preventDefault();
                sign_in(jQuery('#btn_sub_sign_in'));
            });
            jQuery('#forget_form').on('submit', function (e) {
                e.preventDefault();
                forgot(jQuery('#btn_sub_forget'));
            });
        });

        function forgot(btn) {
            var user_login = true;
            var form = jQuery('#forget_form');
            var form_data = jQuery(form).serializeArray();
            jQuery('#forgetFormState').addClass('d-none');
            form_data.push({
                name: 'action',
                value: 'wupp_forget'
            });
            jQuery(form).find('input').each(function () {
                var name = jQuery(this).attr('name');
                var val = jQuery(this).val();
                if (name !== 'token' && (val === undefined || val === '')) {
                    user_login = false;
                }
            });
            if (user_login) {
                jQuery(btn)
                    .addClass('disabled')
                    .attr('disabled', 'disabled')
                    .html(loadingTag);
                $.ajax({
                    data: form_data,
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    complete: function () {
                        jQuery(btn)
                            .removeClass('disabled')
                            .removeAttr('disabled', 'disabled')
                            .html('<?php echo __("Restore", "user-panel-pro") ?>');
                    },
                    success: function (response) {
                        if (response.result === 1) {
                            jQuery('#wupp_forget_auth_pnl').removeClass('d-none');
                            jQuery('#forget_form').addClass('d-none');
                            jQuery('.auth-btn').text(response.btn_text);
                            show_auth_forget();
                            jQuery('#forget_auth_helper').val(response.auth_helper);
                            jQuery('#forget_auth_type').val('verify_restore');
                            start_auth_time(jQuery('#forget_wupp_try_new_code'));
                        } else {
                            jQuery('#forgetFormState')
                                .html(response.message)
                                .removeClass('d-none');
                        }
                    },
                    error: function (e) {
                        jQuery('#forgetFormState')
                            .html('<?php echo __('The information entered is invalid', 'user-panel-pro') ?>')
                            .removeClass('d-none');
                    }
                });
            } else {
                jQuery('#forgetFormState')
                    .html('<?php echo __('Complete form inputs', 'user-panel-pro'); ?>')
                    .removeClass('d-none');
            }
        }

        function auth_in(btn, form_id) {
            var form = jQuery(form_id);
            var data = jQuery(form).serializeArray();
            // check persian and arabic numbers
            data = $.each(data, function (i, field) {
                field.value = convert_number.toNormal(field.value);
            });
            jQuery(form).find('input').each(function () {
                var name = jQuery(this).attr('name');
                if (jQuery(this).val() === '' && name !== 'token' && name !== 'sign_in_auth_type') {
                    data = false;
                }
            });
            data.push({
                name: 'action',
                value: 'wupp_auth'
            });
            jQuery('#authFormState')
                .addClass('d-none');
            if (data) {
                jQuery(btn)
                    .addClass('disabled')
                    .attr('disabled', 'disabled')
                    .html(loadingTag);

                $.ajax({
                    data: data,
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    complete: function () {
                        jQuery(btn)
                            .removeClass('disabled')
                            .removeAttr('disabled', 'disabled')
                            .html('<?php echo __("authentication", "user-panel-pro"); ?>');
                    },
                    success: function (response) {
                        if (response.result === 2) {
                            const queryString = window.location.search;
                            const urlParams = new URLSearchParams(queryString);
                            const redirect = urlParams.get('redirect_to')
                            if (redirect) {
                                location.replace(redirect);
                            } else
                                location.replace(response.redirect_url);
                        } else if (response.result === 1) {
                            jQuery('#forget_wupp_change_password_pnl').prev().addClass('d-none');
                            jQuery('#forget_wupp_change_password_pnl').html(response.content);
                        } else {
                            jQuery('#authFormState')
                                .html(response.message)
                                .removeClass('d-none');
                        }
                    },
                    error: function (e) {
                        jQuery('#authFormState')
                            .html('<?php echo __('No internet connection!', 'user-panel-pro') ?>')
                            .removeClass('d-none');
                    }
                });
            } else {
                jQuery('#authFormState')
                    .html('<?php echo __('Complete form!', 'user-panel-pro'); ?>')
                    .removeClass('d-none');
            }
        }

        function start_auth_time(btn) {
            jQuery(btn)
                .addClass('d-none')
                .attr('disabled', 'disabled')
                .html('<?php echo __('Send code again', 'user-panel-pro'); ?>');
            var time = <?php echo class_exists('WUPPRLTools') ? WUPPRLTools::get_sms_otp_send_again_time() : 0; ?>;
            resendcode(time);
            $time_id = setInterval(function () {
                --time;
                if (time <= 0) {
                    jQuery(btn).html('<?php echo __('Send code again', 'user-panel-pro'); ?>').removeAttr('disabled').removeClass('d-none');
                    clearInterval($time_id);
                }
            }, 1000);
        }

        function try_again(btn, helper_id, type) {
            jQuery(btn)
                .addClass('disabled')
                .attr('disabled', 'disabled')
                .html(loadingTag);
            helper = jQuery('#' + helper_id).val();
            var data = [{
                name: 'helper',
                value: helper
            },
                {
                    name: 'type',
                    value: type
                }
            ];
            data.push({
                name: 'action',
                value: 'wupp_try_again'
            });
            $.ajax({
                data: data,
                type: 'POST',
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                complete: function () {
                    jQuery(btn)
                        .removeClass('disabled')
                        .removeAttr('disabled', 'disabled')
                        .html('<?php echo __("Send code again", "user-panel-pro"); ?>');
                },
                success: function (response) {
                    start_auth_time(btn)
                },
                error: function (e) {
                    jQuery('#authFormState')
                        .html('<?php echo __('No internet connection!', 'user-panel-pro') ?>')
                        .removeClass('d-none');
                }
            });
        }
    </script>
    <!-- process code end  -->
    <script>
        <?php echo WUPPAdminViews::get_option('wupp_login_page_scripts_v2', ''); ?>
    </script>


<?php do_action('wupp_end_login_page'); ?>