<div class="lInputContainer w-100 my-lg-2 my-md-1 ml-md-2 my-sm-3 my-4 ">
    <label for="sign_in_user_name" class="px-2 labels border-right position-absolute">
        <svg
                width="20"
                height="20"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                stroke-width="2"
                stroke-linecap="round"
                stroke-linejoin="round"
                class="feather feather-user-x">
            <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2">
            </path>
            <circle cx="8.5" cy="7" r="4">
            </circle>
            <line class="userX" x1="18" y1="8" x2="23" y2="13">
            </line>
            <line class="userX" x1="23" y1="8" x2="18" y2="13">
            </line>
        </svg>
    </label>
    <input type="text"
           name="user_login"
           id="sign_in_user_name"
           placeholder="<?php echo __("Email or username", "user-panel-pro") ?>"
           maxlength="160"
           class="focusAble  w-75 text-center p-2"
    >
</div>
<div class="lInputContainer w-100 my-lg-3 my-md-3 my-sm-3">
    <label for="sign_in_password" class="px-2 labels border-right position-absolute">
        <svg
                width="18"
                height="18"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                stroke-width="2"
                stroke-linecap="round"
                stroke-linejoin="round"
                class="feather feather-lock">
            <rect x="3" y="11" width="18" height="11" rx="2" ry="2">
            </rect>
            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
        </svg>
    </label>
    <label for="tel" class="passwordLabel px-2 position-absolute">
        <svg
                width="18" height="18"
                viewBox="0 0 24 24" fill="none"
                stroke="currentColor" stroke-width="2"
                stroke-linecap="round" stroke-linejoin="round"
                class="feather feather-eye eye">
            <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z">
            </path>
            <line class="eyeLine" x1="1" y1="1" x2="23" y2="23"></line>
            <circle cx="12" cy="12" r="3"></circle>
        </svg>

    </label>
    <input type="password"
           name="password"
           id="sign_in_password"
           placeholder="<?php echo __("Password", "user-panel-pro") ?>"
           class="focusAble  w-50 text-center p-2"
    >
</div>
<div class="d-flex mr-auto my-xl-1 my-lg-1 my-md-2 my-sm-2 my-3">
    <input type="checkbox" name="wupp_sign_in_remember_me" id="wupp_sign_in_remember_me"
           class="position-relative mr-2 mt-1"/><label class="remMe"
                                                       for="wupp_sign_in_remember_me"><?php echo __('remember me', 'user-panel-pro'); ?></label>
</div>

<script data-role="wupp">
    function sign_in(btn) {
        jQuery('#message_in').addClass('d-none');
        var user_name = jQuery('#sign_in_user_name').val();
        var password = jQuery('#sign_in_password').val();
        var token = jQuery('#token').val();
        var remember_me = jQuery('#wupp_sign_in_remember_me').is(":checked") ? 1 : 0;

        if (!token) {
            token = '';
        }

        if (user_name && password) {
            jQuery(btn)
                .addClass('disabled')
                .attr('disabled', 'disabled')
                .html('<?php echo __("Waiting ...", "user-panel-pro")?>');
            $.ajax({
                data: {
                    user_name: user_name,
                    user_login: user_name,
                    password: password,
                    remember_me: remember_me,
                    token: token
                },
                type: 'POST',
                url: '<?php echo WUPPAdminMethods::get_sign_in_handler_url();?>',
                complete: function () {
                    jQuery(btn)
                        .removeClass('disabled')
                        .removeAttr('disabled', 'disabled')
                        .html('<?php echo __("Login", "user-panel-pro")?>');
                },
                success: function (response) {
                    if (response.result === 2) {
                        const queryString = window.location.search;
                        const urlParams = new URLSearchParams(queryString);
                        const redirect = urlParams.get('redirect_to')
                        if (redirect) {
                            location.replace(redirect);
                        } else
                            location.replace(response.redirect_url);
                    } else if (response.result === 1) {
                        jQuery('#form_sign_in').addClass('d-none');
                        jQuery('#wupp_sign_in_auth_pnl').removeClass('d-none');
                        jQuery('#sign_in_auth_helper').val(response.auth_helper);
                        if (response.auth_type !== undefined && response.auth_type !== null && response.auth_type !== '') {
                            jQuery('#sign_in_auth_type').val(response.auth_type);
                        }
                        start_auth_time(jQuery('#sign_in_wupp_try_new_code'));
                    } else {
                        jQuery('#message_in')
                            .html(response.message)
                            .removeClass('d-none');
                    }
                },
                error: function (e) {
                    jQuery('#message_in')
                        .html('<?php echo __('No internet connection!', 'user-panel-pro')?>')
                        .removeClass('d-none');
                }
            });
        } else {
            jQuery('#message_in')
                .html('<?php echo __('Complete form', 'user-panel-pro');?>')
                .removeClass('d-none');
        }
    }
</script>