<?php $settings = WUPPRLTools::wupp_get_new_login_settings(); ?>
    <div class="lInputContainer w-100 my-lg-2 my-md-1 ml-md-2 my-sm-3 my-4 ">
        <label for="sign_in_user_name" class="px-2 labels border-right position-absolute">
            <svg
                    width="20"
                    height="20"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    stroke-width="2"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    class="feather feather-user-x">
                <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2">
                </path>
                <circle cx="8.5" cy="7" r="4">
                </circle>
                <line class="userX" x1="18" y1="8" x2="23" y2="13">
                </line>
                <line class="userX" x1="23" y1="8" x2="18" y2="13">
                </line>
            </svg>
        </label>
        <input type="text"
               name="user_login"
               id="sign_in_user_name"
               placeholder="<?php echo WUPPRLLogin::get_id_title(); ?>"
               maxlength="160"
               class="focusAble w-75 text-center p-2"
        >
    </div>
<?php if ($settings['use_password'] == '1'): ?>
    <div class="lInputContainer w-100 my-lg-3 my-md-3 my-sm-3">
        <label for="sign_in_password" class="px-2 labels border-right position-absolute">
            <svg
                    width="18"
                    height="18"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    stroke-width="2"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    class="feather feather-lock">
                <rect x="3" y="11" width="18" height="11" rx="2" ry="2">
                </rect>
                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
            </svg>
        </label>
        <label for="tel" class="passwordLabel px-2 position-absolute">
            <svg
                    width="18" height="18"
                    viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2"
                    stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-eye eye">
                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z">
                </path>
                <line class="eyeLine" x1="1" y1="1" x2="23" y2="23"></line>
                <circle cx="12" cy="12" r="3"></circle>
            </svg>

        </label>
        <input type="password"
               name="password"
               id="sign_in_password"
               placeholder="<?php echo __("Password", "user-panel-pro") ?>"
               class="focusAble  w-50 text-center p-2"
               maxlength="70"
        >
    </div>
<?php endif; ?>
    <div class="d-flex mr-auto my-xl-1 my-lg-1 my-md-2 my-sm-2 my-3 remember_me">
        <input type="checkbox" name="wupp_sign_in_remember_me" id="wupp_sign_in_remember_me"
               class="position-relative mr-2 mt-1"/><label class="remMe"
                                                           for="wupp_sign_in_remember_me"><?php echo __('remember me', 'user-panel-pro'); ?></label>
    </div>

<?php if ($settings['use_password'] == '1' && $settings['allow_send_validation_code'] == '1'): ?>
    <?php add_action('wupp_login_form_button', function () {
        ?>
        <button type="button" class="login-with-otp btn btn-primary mt-lg-2 mt-md-1 mt-sm-2 mt-xs-2 w-50 mx-auto"
                id="wupp_sign_in_code_btn">
            <?php echo __("Send code", "user-panel-pro") ?>
        </button>
        <script>
            jQuery(document).ready(function () {
                jQuery('.login-with-otp').on('click', function (e) {
                    jQuery('#sign_in_password').parent().addClass('d-none');
                });
            });
        </script>
        <?php
    }); ?>
<?php endif; ?>