jQuery(document).ready(function ($) {
    $(function () {
        $('input[data-actiontype="mobile"]').each(function () {
            var myMask = $(this).attr('data-pattern');
            if (myMask !== '-1') {
                try {
                    $(this).mask(myMask);
                    $(this).attr('maxlength', myMask.length)
                } catch (e) {

                }
            }
        });
        $('input[data-actiontype="nationalid_length"]').each(function () {
            var myMask = $(this).attr('data-pattern');
            if (myMask === 'iran') {
                $(this).attr('maxlength', '10');
                $(this).attr('minlength', '10')
            }
        });
        $('div[data-datefield="datefield"]').each(function () {
            var parent = this;
            $(this).find('input, select').on('change click paste keyup', function () {
                var inputs = $(parent).find('input, select');
                var target = $(this).attr('data-target');
                var date = '';

                for (var i = inputs.length - 0; i >= 0; i--) {
                    var elm = inputs[i];
                    var type = $(elm).attr('data-type');
                    if (type === 'd' || type === 'y' || type === 'm') {
                        if (date !== '') {
                            date += '-';
                        }
                        date += $(elm).val();
                    }
                }


                $(target).val(date);
            });
        });
        $('input[data-action="persiandate"]').each(function () {
            // kamaDatepicker($(this).attr('id'), {});
            jalaliDatepicker.startWatch();
        });
        $('div[data-action="time"]').each(function () {
            var parent = this;
            $(this).find('input, select').on('click paste change keyup', function () {
                var target = $(this).attr('data-target');
                var time = '';

                $(parent).find('input, select').each(function () {
                    var value = $(this).val();
                    if (!$(this).is('select') && time !== '') {
                        time += ':';
                    }

                    if ($(this).is('select')) {
                        time += " " + value;
                    } else {
                        time += value;
                    }
                });
                $(target).val(time);
            });
        });

        var passwords = $('input[data-action="wupp-password"]');
        passwords.on('click change paste keyup', function () {
            if (passwords.length > 1) {
                check_password_in_register(this);
            }
        });
        if (passwords.length > 1) {
            $('#btn_sub_sign_up').attr('disabled', 'disabled').addClass('disabled')
            $('#wupp_update_profile').attr('disabled', 'disabled').addClass('disabled')
        }


    })

    document.addEventListener("DOMContentLoaded", function () {
        var elements = $('#form_sign_up').find('input');
        for (var i = 0; i < elements.length; i++) {
            elements[i].oninvalid = function (e) {
                e.target.setCustomValidity("");
                if (!e.target.validity.valid) {
                    e.target.setCustomValidity($('#wupp_rl_validate_messgae').html());
                    $(this).addClass('border-danger');
                }
            };
            elements[i].oninput = function (e) {
                e.target.setCustomValidity("");
                $(this).removeClass('border-danger');
            };
        }
    })

    function check_password_in_register(elm) {
        var isCurrent = true;

        $('input[data-action="wupp-password"]').each(function () {
            var val1 = $(this).val();
            var val2 = $($(this).attr('data-target')).val();

            if (val1 !== undefined && val2 !== undefined && val1 !== '' && val2 !== '' && val1 === val2) {
            } else {
                isCurrent = false;
            }
        });

        if (isCurrent) {
            $('#btn_sub_sign_up').removeAttr('disabled', 'disabled').removeClass('disabled')
            $('#wupp_update_profile').removeAttr('disabled', 'disabled').removeClass('disabled')
        } else {
            $('#btn_sub_sign_up').attr('disabled', 'disabled').addClass('disabled');
            $('#wupp_update_profile').attr('disabled', 'disabled').addClass('disabled');
        }
    }
});