function rl_get_new_bot_item(type, url, btn) {
    var count = rl_get_fields_count();
    var btn_content = jQuery(btn).html();
    jQuery(btn).html(rl_get_spinner_elm('text-primary'));
    jQuery('#register_fields').find('button').attr('disabled', 'disabled')
        .addClass('disabled')

    var data = [
        {name: 'field_type', value: type},
        {name: 'field_count', value: count},
        {name: 'action', value: 'wupp_ajax_rl_new_register_bot_item'},
    ];
    jQuery.ajax({
        data: data,
        url: url,
        type: 'POST',
        complete: function () {
            jQuery(btn).html(btn_content);
            jQuery('#register_fields').find('button').removeAttr('disabled')
                .removeClass('disabled')
        },
        success: function (response) {
            jQuery('#wupp_rl_bot_message_pnl').html(rl_get_alert_content(response.message));
            if (response.result === 2) {
                jQuery('#register_fields_pnl')
                    .append(response.content)
                    .sortable()
                    .disableSelection();
                jQuery('.wupp-inner-sort')
                    .sortable()
                    .disableSelection();
                rl_tag_label_bot();
                rl_date_icon_changer();
                _rl_handel_select_save_key_listener();
            }
        },
        error: function (e) {
        }
    });
}

function rl_get_fields_count(lenSet) {
    var childes = jQuery('#register_fields_pnl').children();
    var len = (lenSet && lenSet >= 0) ? lenSet : childes.length + 1;
    childes.each(function () {
        var count = parseInt(jQuery(this).attr('data-count'));
        if (count === len) {
            len = rl_get_fields_count(len + 1);
        }
    });

    return len;
}

function rl_get_spinner_elm(color) {
    return '<div class="spinner-grow ' + color + ' spinner-grow-sm" role="status"></div>';
}

function rl_get_alert_content(message) {
    var inID = setInterval(function () {
        jQuery('#wupp_rl_bot_message_pnl').empty();
        clearInterval(inID);
    }, 5000);
    return '<div class="toast fade show mt-4" role="alert" aria-live="assertive" aria-atomic="true">' +
        '  <div class="toast-header position-relative" style="height: 40px">' +
        '    <i class="fas fa-info-circle position-absolute" style="left: 12px"></i>' +
        '    <button type="button" onclick="jQuery(\'#wupp_rl_bot_message_pnl\').empty()" class="ml-2 mb-1 close shadow-none border-0 position-absolute" style="right: 12px" data-dismiss="toast" aria-label="Close">' +
        '      <span aria-hidden="true">&times;</span>' +
        '    </button>' +
        '  </div>' +
        '  <div class="toast-body">' +
        message +
        '  </div>' +
        '</div>';
}

function rl_remove_item(elm, single) {
    var parentElm = jQuery(elm).parent();

    if (parentElm && parentElm.is('li')) {
        if (single) {
            var liParent = jQuery(parentElm).parent();
            if (jQuery(liParent).children().length > 1) {
                parentElm.remove();
            }
        } else {
            parentElm.remove();
        }

    } else {
        rl_remove_item(parentElm, single);
    }
}

function rl_tag_label_bot() {
    jQuery('.wupp-tag-inp').each(function () {
        jQuery(this).on('click paste change keyup', function () {
            var count = jQuery(this).attr('id').replace('slt', '');
            count = count.replace('_tag_input', '');

            var label = jQuery(this).attr('data-label');
            var value = jQuery(this).val();
            var elm = jQuery('#' + label);

            if (value && value !== '') {
                jQuery(elm).html(value);
                jQuery('#wupp_header_' + count).html(value);
            } else {
                jQuery(elm).html(jQuery(elm).attr('data-default'));
                jQuery('#wupp_header_' + count).html(jQuery(elm).attr('data-default'));
            }
        });
        var label = jQuery(this).attr('data-label');
        var value = jQuery(this).val();
        var elm = jQuery('#' + label);

        if (value && value !== '') {
            jQuery(elm).html(value);
        } else {
            jQuery(elm).html(jQuery(elm).attr('data-default'));
        }
    });
}

function rl_get_list_item(id, name) {
    return '<li class="mt-2"><div >' +
        '                                <i class="fas fa-sort float-start cursor-move mt-2"></i>' +
        '                                <div class="row">' +
        '                                    <div class="col-auto">' +
        '                                        <div class="form-check">' +
        '                                            <input class="form-check-input mt-2" name="' + name + '" type="radio">' +
        '                                        </div>' +
        '                                    </div>' +
        '                                    <div class="col-9 p-0 radios-labels">' +
        '                                        <div class="form-group mb-0">' +
        '                                             <input type="text" maxlength="100" name="list_labels" class="form-control form-control-sm">' +
        '                                        </div>' +
        '                                    </div>' +
        '                                    <div class="col-5 radios-values d-none">' +
        '                                        <div class="form-group mb-0">' +
        '                                            <input type="text" maxlength="100" name="list_values" class="form-control form-control-sm">' +
        '                                        </div>' +
        '                                    </div>' +
        '                                    <div class="col-auto p-0">' +
        '                                        <i class="fas fa-plus-circle wupp-cursor-pointer mt-1" onclick="rl_add_list_item(this, ' + id + ', ' + name + ')" style="font-size: 1.3em"></i>' +
        '                                        <i class="fas fa-minus-circle wupp-cursor-pointer mt-1" onclick="rl_remove_item(this, true)" style="font-size: 1.3em"></i>' +
        '                                    </div>' +
        '                                </div>' +
        '                            </div></li>';
}

function rl_add_list_item(btn, id, name) {
    var parentElm = jQuery(btn).parent();

    if (parentElm && parentElm.is('li')) {
        jQuery(rl_get_list_item(id, name)).insertAfter(parentElm);
        rl_toggle_values(jQuery('#slt_show_values_input_' + id), 'wupp_list_sort_' + id);
    } else {
        rl_add_list_item(parentElm, id, name);
    }
}

function rl_toggle_values(elm, type) {
    var checked = jQuery(elm).is(':checked');
    if (checked) {
        jQuery('#' + type).find('.radios-labels').removeClass('col-9 col-4').addClass('col-4');
        jQuery('#' + type).find('.radios-values').removeClass('d-none');
    } else {
        jQuery('#' + type).find('.radios-labels').removeClass('col-9 col-4').addClass('col-9');
        jQuery('#' + type).find('.radios-values').addClass('d-none');
    }
}

function rl_date_changer(elm, parent, id) {
    var val = jQuery(elm).val();
    switch (val) {
        case 'datefield':
            jQuery('#' + parent).find('.tags-label').removeClass('d-none');
            jQuery('#' + parent).find('.sub-tags').removeClass('d-none');

            jQuery('#' + parent).find('.icon-label').addClass('d-none');
            jQuery('#' + parent).find('.icon-options').addClass('d-none');
            jQuery('#' + parent).find('.icon-url').addClass('d-none');
            break;
        case 'datepicker':
            jQuery('#' + parent).find('.icon-label').removeClass('d-none');
            jQuery('#' + parent).find('.icon-options').removeClass('d-none');
            if (jQuery('#slt' + id + '_date_iconcustom').is(':checked')) {
                jQuery('#' + parent).find('.icon-url').removeClass('d-none');
            } else {
                jQuery('#' + parent).find('.icon-url').addClass('d-none');
            }
            jQuery('#' + parent).find('.tags-label').addClass('d-none');
            jQuery('#' + parent).find('.sub-tags').addClass('d-none');
            break;
        case 'datedropdown':
            jQuery('#' + parent).find('.icon-label').addClass('d-none');
            jQuery('#' + parent).find('.icon-options').addClass('d-none');
            jQuery('#' + parent).find('.icon-url').addClass('d-none');
            jQuery('#' + parent).find('.tags-label').addClass('d-none');
            jQuery('#' + parent).find('.sub-tags').addClass('d-none');
            break;
    }
}

function rl_date_icon_changer() {
    jQuery('.icon-options').each(function () {
        var id = jQuery(this).attr('data-id');
        var parent = jQuery(this).parent();
        jQuery('#slt' + id + '_date_iconno').on('change', function () {
            jQuery(parent).find('.icon-url').addClass('d-none');
        });
        jQuery('#slt' + id + '_date_iconcalender').on('change', function () {
            jQuery(parent).find('.icon-url').addClass('d-none');
        });
        jQuery('#slt' + id + '_date_iconcustom').on('change', function () {
            jQuery(parent).find('.icon-url').removeClass('d-none');
        });
    });
}

function rl_convert_select2_items(items) {
    var myItems = [];

    for (let i = 0; i < items.length; i++) {
        myItems.push(items[i]['id']);
    }

    return myItems;
}

function rl_save_bot_items(elm) {
    var btn_content = jQuery(elm).html();
    var btn_no_items = jQuery(elm).attr('data-no-message');
    var data_repeatkey_message = jQuery(elm).attr('data-repeatkey-message');
    var data_nokey_message = jQuery(elm).attr('data-nokey-message');

    jQuery(elm).html(rl_get_spinner_elm('text-light'));
    jQuery('#register_fields').find('button').attr('disabled', 'disabled')
        .addClass('disabled')


    var items = [];
    var keys = [];
    var titles = [];

    var noKeyErr = '';
    jQuery('#register_fields_pnl').children().each(function () {
        var type = jQuery(this).attr('data-type');
        var count = jQuery(this).attr('data-count');

        switch (type) {
            case 'field_roles':
                item = _rl_get_role_obj(count);
                break;
            case 'field_first_last_name':
                item = _rl_get_firstname_lastname_obj(count);
                break;
            case 'field_display_name':
                item = _rl_get_display_name_obj(count);
                break;
            case 'field_national_id':
                item = _rl_get_national_id_obj(count);
                break;
            case 'field_mobile':
                item = _rl_get_mobile_obj(count);
                break;
            case 'field_address':
                item = _rl_get_address_obj(count);
                break;
            case 'field_password':
                item = _rl_get_password_obj(count);
                break;
            case 'field_website':
                item = _rl_get_website_obj(count);
                break;
            case 'field_email':
                item = _rl_get_email_obj(count);
                break;
            case 'field_postal_code':
                item = _rl_get_postal_code_obj(count);
                break;
            case 'field_username':
                item = _rl_get_username_obj(count);
                break;
            case 'field_single_line_text':
                item = _rl_get_single_line_text_obj(count);
                break;
            case 'field_paragraph':
                item = _rl_get_paragraph_obj(count);
                break;
            case 'field_radio_group':
                item = _rl_get_radio_buttons_obj(count);
                break;
            case 'field_dropdown_list':
                item = _rl_get_dropdown_menus_obj(count);
                break;
            case 'field_separator':
                item = _rl_get_separator_obj(count);
                break;
            case 'field_number':
                item = _rl_get_numerical_obj(count);
                break;
            case 'field_date':
            case 'field_birthday_date':
                item = _rl_get_date_obj(count);
                break;
            case 'field_time':
                item = _rl_get_time_obj(count);
                break;
        }
        if(type === 'field_first_last_name'){
            //first name
            var firstTheKey = '';
            if(item.first_name_custom_save_key !== undefined && item.first_name_custom_save_key !== ''){
                firstTheKey = item.first_name_custom_save_key;
            }else {
                firstTheKey = item.first_name_save_key;
            }
            keys.push(firstTheKey);

            //last name
            var lastTheKey = '';
            if(item.last_name_custom_save_key !== undefined && item.last_name_custom_save_key !== ''){
                lastTheKey = item.last_name_custom_save_key;
            }else {
                lastTheKey = item.last_name_save_key;
            }
            keys.push(lastTheKey);
            titles.push(item.title);

            if((item.first_name_save_key === '' && item.first_name_custom_save_key === '') || (item.last_name_save_key === '' && item.last_name_custom_save_key === '')){
                noKeyErr += item.title + '<br>';
            }
        }else {
            var theKey = '';
            if(item.custom_save_key !== undefined && item.custom_save_key !== ''){
                theKey = item.custom_save_key;
            }else {
                theKey = item.save_key;
            }
            keys.push(theKey);

            if(item.save_key === '' && item.custom_save_key === ''){
                noKeyErr += item.title + '<br>';
            }
        }
        titles.push(item.title);
        items.push(item);
    });

    var err = check_have_dubel_keys(keys, titles);
    if(err !== '' || noKeyErr !== ''){
        jQuery(elm).html(btn_content);
        jQuery('#register_fields').find('button').removeAttr('disabled')
            .removeClass('disabled')

        var errContent = '';
        if(err !== ''){
            errContent = data_repeatkey_message + '<br>' + err;
        }
        if(noKeyErr !== ''){
            errContent = data_nokey_message + '<br>' + noKeyErr;
        }
        jQuery('#wupp_rl_bot_message_pnl').html(rl_get_alert_content(errContent));
    }else if (items.length > 0) {
        var items_json = JSON.stringify(items);
        var data = [
            {name: 'action', value: 'wupp_ajax_rl_request_save_register_form_bot_items'},
            {name: 'form_data', value: items_json}
        ];

        jQuery.ajax({
            data: data,
            url: ajaxurl,
            type: 'POST',
            complete: function () {
                jQuery(elm).html(btn_content);
                jQuery('#register_fields').find('button').removeAttr('disabled')
                    .removeClass('disabled')
            },
            success: function (response) {
                jQuery('#wupp_rl_bot_message_pnl').html(rl_get_alert_content(response.message));
            },
            error: function (e) {
            }
        });
    } else {
        jQuery(elm).html(btn_content);
        jQuery('#register_fields').find('button').removeAttr('disabled')
            .removeClass('disabled')
        jQuery('#wupp_rl_bot_message_pnl').html(rl_get_alert_content(btn_no_items));
    }
}

function check_have_dubel_keys(keys, values) {
    var err = '';

    for (let i = 0; i < keys.length; i++) {
        var key = keys[i];
        for (let j = 0; j < keys.length; j++) {
            if(j !== i && key === keys[j]){
                err += values[j] + '<br>';
            }
        }
    }

    return err;
}

function _rl_get_display_name_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();
    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_display_name',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_time_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var hour_type = jQuery('#slt' + count + '_date_type').val();
    var dateph_mm = jQuery('#slt' + count + '_dateph_mm_input').val();
    var dateph_hh = jQuery('#slt' + count + '_dateph_hh_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_time',
        'hour_type': hour_type,
        'dateph_mm': dateph_mm,
        'dateph_hh': dateph_hh,
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
    };
}

function _rl_get_date_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var dateType = jQuery('#slt' + count + '_date_type').val();
    var dateFormat = jQuery('#slt' + count + '_date_format').val();
    var iconType = _rl_found_check_radio('slt' + count + '_date_icon');
    var iconUrl = jQuery('#slt' + count + '_icon_url').val();

    var dateph_mm = jQuery('#slt' + count + '_dateph_mm_input').val();
    var dateph_dd = jQuery('#slt' + count + '_dateph_dd_input').val();
    var dateph_yyyy = jQuery('#slt' + count + '_dateph_yyyy_input').val();


    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var enabelShamsi = jQuery('#slt' + count + '_enable_shamsi_input').is(':checked');

    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_date',
        'enabel_shamsi': enabelShamsi,
        'dateph_yyyy': dateph_yyyy,
        'dateph_dd': dateph_dd,
        'dateph_mm': dateph_mm,
        'title': title,
        'description': description,
        'date_type': dateType,
        'icon_type': iconType,
        'icon_url': iconUrl,
        'date_format': dateFormat,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey
    };
}

function _rl_found_check_radio(name) {
    var checkedVal = '';
    jQuery('input[name="' + name + '"]').each(function () {
        if (jQuery(this).is(':checked')) {
            checkedVal = jQuery(this).val();
        }
    });

    return checkedVal;
}

function _rl_get_numerical_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_number',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_separator_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var customCssClass = jQuery('#slt' + count + '_css_input').val();

    return {
        '__type': 'field_separator',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'custom_css_class': customCssClass,
    };
}

function _rl_get_dropdown_menus_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var list = _rl_get_groups_list(jQuery('#wupp_list_sort_' + count))
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');

    var customCssClass = jQuery('#slt' + count + '_css_input').val();

    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_dropdown_list',
        'title': title,
        'description': description,
        'items': list,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
    };
}

function _rl_get_radio_buttons_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var list = _rl_get_groups_list(jQuery('#wupp_list_sort_' + count))
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');

    var customCssClass = jQuery('#slt' + count + '_css_input').val();

    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_radio_group',
        'title': title,
        'description': description,
        'items': list,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey
    };
}

function _rl_get_groups_list(elmUL) {
    var list = [];
    jQuery(elmUL).children().each(function () {

        var isChecked = false;
        var label = '';
        var value = '';
        jQuery(this).find('input').each(function () {
            var name = jQuery(this).attr('name');
            switch (name) {
                case 'list_labels':
                    label = jQuery(this).val();
                    break;
                case 'list_values':
                    value = jQuery(this).val();
                    break;
            }
            if(jQuery(this).attr('type') === 'radio'){
                isChecked = jQuery(this).is(':checked');
            }
        });

        list.push({
            'is_checked': isChecked,
            'label': label,
            'value': value
        });
    });

    return list;
}

function _rl_get_paragraph_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_paragraph',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_single_line_text_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_single_line_text',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_username_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_username',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_postal_code_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_postal_code',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_email_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_email',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_website_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_website',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_password_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var repeatPassword = jQuery('#slt' + count + '_password_repeat_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_password',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'password_repeat': repeatPassword,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_address_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_address',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'max_char_length': maxChars,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_mobile_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var mobileAlgo = jQuery('#slt' + count + '_mobile_algo').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_mobile',
        'title': title,
        'description': description,
        'mobile_algo': mobileAlgo,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'placeholder': placeHolder,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_national_id_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();

    var invalidMessage = jQuery('#slt' + count + '_nationalid_invalid_input').val();
    var invalidCountMessage = jQuery('#slt' + count + '_nationalid_invalidcount_input').val();
    var invalidAlgoMessage = jQuery('#slt' + count + '_nationalid_invalidalgo_input').val();
    var invalidExistMessage = jQuery('#slt' + count + '_nationalid_exist_input').val();


    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var showCity = jQuery('#slt' + count + '_showcity_nationalid_input').is(':checked');
    var useSpace = jQuery('#slt' + count + '_spaceseparator_nationalid_input').is(':checked');
    var translate = jQuery('#slt' + count + '_translate_nationalid_input').is(':checked');


    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();

    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_national_id',
        'title': title,
        'description': description,
        'invalid_message': invalidMessage,
        'invalid_count_message': invalidCountMessage,
        'invalid_algo_message': invalidAlgoMessage,
        'invalid_exist_message': invalidExistMessage,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'show_city': showCity,
        'use_space': useSpace,
        'translate': translate,
        'placeholder': placeHolder,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey,
        'default_value': defaultValue,
    };
}

function _rl_get_firstname_lastname_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var placeHolder = jQuery('#slt' + count + '_placeholder_input').val();
    var lastnamePlaceHolder = jQuery('#slt' + count + '_placeholder_lastname_input').val();
    var maxChars = jQuery('#slt' + count + '_max_len_input').val();
    var lastnameMaxChars = jQuery('#slt' + count + '_max_len_lastname_input').val();
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var lastnameStorageKey = jQuery('#slt' + count + '_save_key_lastname_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var lastnameCustomStorageKey = jQuery('#slt' + count + '_custom_save_key_lastname_input').val();
    var defaultValue = jQuery('#slt' + count + '_default_value_input').val();
    var lastnameDefaultValue = jQuery('#slt' + count + '_default_value_lastname_input').val();
    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_first_last_name',
        'title': title,
        'description': description,
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'first_name_placeholder': placeHolder,
        'last_name_placeholder': lastnamePlaceHolder,
        'first_name_max_char_length': maxChars,
        'last_name_max_char_length': lastnameMaxChars,
        'custom_css_class': customCssClass,
        'first_name_save_key': storageKey,
        'last_name_save_key': lastnameStorageKey,
        'first_name_custom_save_key': customStorageKey,
        'last_name_custom_save_key': lastnameCustomStorageKey,
        'first_name_default_value': defaultValue,
        'last_name_default_value': lastnameDefaultValue,
    };
}

function _rl_get_role_obj(count) {
    var title = jQuery('#slt' + count + '_tag_input').val();
    var description = jQuery('#slt' + count + '_description_input').val();
    var roles = jQuery('#slt' + count + '_roles_list_input').select2('data');
    var showInProfileEdit = jQuery('#slt' + count + '_showin_profile_input').is(':checked');
    var showInRegisterForm = jQuery('#slt' + count + '_showin_register_input').is(':checked');
    var required = jQuery('#slt' + count + '_require_input').is(':checked');
    var customCssClass = jQuery('#slt' + count + '_css_input').val();
    var storageKey = jQuery('#slt' + count + '_save_key_input').val();
    var customStorageKey = jQuery('#slt' + count + '_custom_save_key_input').val();
    var is_login_field = jQuery('#slt' + count + '_is_login_field_input').is(':checked');

    return {
        'is_login_field': is_login_field,
        '__type': 'field_roles',
        'title': title,
        'description': description,
        'roles': rl_convert_select2_items(roles),
        'show_in_profile_edit': showInProfileEdit,
        'show_in_register_form': showInRegisterForm,
        'required': required,
        'custom_css_class': customCssClass,
        'save_key': storageKey,
        'custom_save_key': customStorageKey
    };
}

function _rl_handel_select_save_key_listener() {
    jQuery('#register_fields_pnl').children().each(function () {
        var count = jQuery(this).attr('data-count');
        jQuery('#slt' + count + '_save_key_input').attr('onchange', 'rl_check_selected_save_key(' + count + ')');
        jQuery('#slt' + count + '_custom_save_key_input').on('change paste click keyup', function () {
            rl_check_selected_save_key(count);
        });
    });
}

function rl_check_selected_save_key(cou){
    var elmSelect = jQuery('#slt' + cou + '_save_key_input');
    var elmInput = jQuery('#slt' + cou + '_custom_save_key_input');

    var keySelect = jQuery(elmSelect).val();
    var keyInput = jQuery(elmInput).val();
    var haveSaveKey = false;

    jQuery('#register_fields_pnl').children().each(function () {
        var count = parseInt(jQuery(this).attr('data-count'));
        if(count !== parseInt(cou)){
            var keyS = jQuery('#slt' + count + '_save_key_input').val();
            var keyS2 = jQuery('#slt' + count + '_save_key_lastname_input').val();

            var keyI = jQuery('#slt' + count + '_custom_save_key_input').val();
            var keyI2 = jQuery('#slt' + count + '_custom_save_key_lastname_input').val();

            if(keyInput === undefined || keyInput === ''){
                if(keySelect === keyS || keySelect === keyI){
                    haveSaveKey = true;
                }else if(keyS2 !== undefined && (keySelect === keyS2 || keySelect === keyI2)){
                    haveSaveKey = true;
                }
            }else {
                if(keyInput === keyS || keyInput === keyI){
                    haveSaveKey = true;
                }else if(keyI2 !== undefined && (keyInput === keyS2 || keyInput === keyI2)){
                    haveSaveKey = true;
                }
            }
        }
    });

    var id = 'save_key_error_' + cou;
    jQuery('#' + id).remove();
    if(haveSaveKey){
        jQuery(elmSelect).parent().append('<small id="'+id+'" class="form-text text-danger">'+jQuery('#register_fields_pnl').attr("data-error")+'</small>');
    }
}

jQuery(function () {
    jQuery('#register_fields').find('button').each(function () {
        jQuery(this).on('click', function () {
            var type = jQuery(this).attr('data-type');
            if (type !== undefined && type !== '') {
                rl_get_new_bot_item(type, ajaxurl, this);
            }
        });
    });

    jQuery('#register_fields_pnl')
        .sortable()
        .disableSelection();
    rl_tag_label_bot();
    rl_date_icon_changer()
    _rl_handel_select_save_key_listener();
})